package com.nicbase.boxdata;

import lombok.ToString;

import com.nicbase.tools.serialisation.json.ICustomizedJSONEnum;

/**
 * @author Henrik Westphal
 *         TODO refactoring use explicit set internal id not the enums ORDINAL !!!!
 */
@ToString
public enum Event implements ICustomizedJSONEnum {

    /**
     * NEVER EVER MOVE ANY LINE, ALWAYS ADD NEW FIELDS TO THE END!
     * NEVER EVER MOVE ANY LINE, ALWAYS ADD NEW FIELDS TO THE END!
     * NEVER EVER MOVE ANY LINE, ALWAYS ADD NEW FIELDS TO THE END!
     * NEVER EVER MOVE ANY LINE, ALWAYS ADD NEW FIELDS TO THE END!
     * NEVER EVER MOVE ANY LINE, ALWAYS ADD NEW FIELDS TO THE END!
     */
    DO_NOT_USE, //
    DOOR_OPENED, //
    DOOR_CLOSED, //
    REEFER_ACTIVATED, //
    REEFER_DEACTIVATED, //
    COUPLED, //
    DECOUPLED, //
    SETPOINT_CHANGED, //
    CHARGER_DETACHED, //
    START_MOVING, //
    STOP_MOVING, //
    CHARGER_ATTACHED, //
    FIXED_INTERVAL_MESSAGE, //
    TCC_AED, //
    DOORLOCK_DOOR_ENABLED, // Doorlock was released by typing in an correct PIN.
    DOORLOCK_DOOR_DISABLED, //
    DOORLOCK_KEYPAD_ACTIVE, // It is possible to type in the PIN at the keypad.
    DOORLOCK_KEYPAD_INACTIVE, // It is NOT possible to type in the PIN at the keypad.
    DOORLOCK_UNLOCK_ENABLED, // The command 'UNLOCK' was enabled. (Vanloxx)
    DOORLOCK_UNLOCK_DISABLED, //
    DOORLOCK_ALARM_DOOR_OPENED, // Door contact open without door release.
    DOORLOCK_ALARM_DOOR_CLOSED, //
    APP_START, //
    APP_STOP, //
    APP_BREAK, //
    APP_TRAFFIC, //
    APP_BREAKDOWN, //
    APP_DELAY, //
    IGNITION_ONLY, //
    TCC_KEEP_ALIVE, //
    LOW_BATTERY_LEVEL, //
    MIL,
    PANIC_BUTTON_ACTIVE,
    PANIC_BUTTON_INACTIVE;

    /**
     * This method returns the Ebs Type by ordinal
     *
     * @param ordinal
     * @return Ebs Type or null if ordinal is invalid
     */
    public static Event fromOrdinal(final int ordinal) {
        if (ordinal < 0 || ordinal >= Event.values().length) {
            return null;
        }
        return Event.values()[ordinal];
    }

    /*
     * (non-Javadoc)
     *
     * @see com.nicbase.tools.serialisation.json.ICustomizedJSONEnum#getDatabaseRepresentation()
     */
    @Override
    public Object getDatabaseRepresentation() {
        return this.ordinal();
    }

}
