package com.nicbase.boxdata;

public enum OperationType {
    /**
     * Continuous run.
     * 
     * Temperature is regulated by heating and cooling.
     */
    CONTINUOUS,

    /**
     * Start stop.
     * 
     * Temperature is regulated only by cooling,
     * if it gets cold enough, the reefer is stopped
     * and the temperature increases again by the
     * ambient temperature.
     */
    START_STOP,

    /**
     * The operation mode is unknown
     */
    UNKNOWN,

    /**
     * High speed mode.
     * 
     * Temperature is regulated for a short time under full load.
     */
    HIGH_SPEED,

    /**
     * This is a special operation type for the demeter reefer. It is used when no ohter available operation type
     * suits the current state.
     */
    OFF,

    /**
     * Initialisation phase of the reefer controller.
     */
    CHECK_MODE,

    /**
     * Target temperature reached.
     */
    START_STOP_SETPOINT_REACHED,

    /**
     * Target temperature not reached.
     */
    START_STOP_SETPOINT_NOT_REACHED,

    /**
     * Manual defrosting.
     */
    MANUAL_DEFROST,

    /**
     * Manual dehumidity.
     */
    MANUAL_DEHUMIDITY,

    /**
     * Manual ventilation.
     */
    MANUAL_VENTILATION,

    /**
     * Manual no concerning MANUAL_DEFROST, MANUAL_DEHUMIDITY, MANUAL_VENTILATION
     */
    MANUAL;


    public static OperationType fromOrdinal(final int i) {
        if (i < 0 || i >= OperationType.values().length) {
            return null;
        }
        return OperationType.values()[i];
    }
}