package com.nicbase.boxdata;

/**
 * Enum for distinguishing how the reefer is powered.
 * 
 * @author Carsten Strauss
 * 
 */
public enum PowerType {

	// reefer is powered by internal diesel engine
	DIESEL,

	// reefer is powered by external power cable
	ELECTRIC,
	
	// reefer power type is unknown or not submitted
	UNKNOWN,

	// reefer is powered by an internal battery
	BATTERY;
	
	public static PowerType fromOrdinal(final int i) {
		if (i < 0 || i >= PowerType.values().length) {
			return null;
		}
		return PowerType.values()[i];
	}

}
