package com.nicbase.boxdata;

public enum ReeferManufacturer {

    CARRIER(0),
    THERMOKING(1),
    UNKNOWN(2),
    CARRIER_STANDARD(3),
    CARRIER_DC500(4),
    CARRIER_DC600(5),
    TRANSSCAN(6),
    DEMETER(7),
    MITSUBISHI(8);

    int	ordinal;

    ReeferManufacturer(final int ordinal) {
        this.ordinal = ordinal;
    }

    public static ReeferManufacturer fromOrdinal(final int ordinal) {
        for (final ReeferManufacturer as : ReeferManufacturer.values()) {
            if (as.ordinal == ordinal) {
                return as;
            }
        }
        return null;
    }

    public static ReeferManufacturer byName(final String state) {
        for (final ReeferManufacturer as : ReeferManufacturer.values()) {
            if (as.name().equals(state)) {
                return as;
            }
        }
        return null;
    }

    public int getValue() {
        return ordinal;
    }
}
